<?php namespace App\Http\Controllers;
use App\User;
use App\Profile;
use Validator;
use Session;
use Auth;
use Redirect;
use App\ProfileViews;
use Datatables;
use GeoIP;

class ViewsController extends Controller {

	public function __construct()
	{
		// Check credentials
		$this->middleware('auth');
		if(!Session::get('auth_selected_profile')) {
			return Redirect::to('profile/step1')->with('succ_msg', 'Please Create atleast one profile')->send(); 
		}
		$this->current_profile_id = Session::get('auth_selected_profile');
	}

	public function index()
	{
		// default view
		$view_count = ProfileViews::getViewCount(Session::get('auth_selected_profile'), 15);
		$more_view_count = ProfileViews::getViewCount(Session::get('auth_selected_profile'), 15, '<=');
		$visitor_profiles = ProfileViews::getVisitorsList(Session::get('auth_selected_profile'), 15);
		$chart_data = ProfileViews::getChartData(Session::get('auth_selected_profile'));

		// last 90 days
		$view_count_90 = ProfileViews::getViewCount(Session::get('auth_selected_profile'), 90);
		// last 60 days
		$view_count_60 = ProfileViews::getViewCount(Session::get('auth_selected_profile'), 60);
		// last 30 days
		$view_count_30 = ProfileViews::getViewCount(Session::get('auth_selected_profile'), 30);

		$arr_views = array(
			'view_count' 		=> $view_count,
			'more_view_count'	=> $more_view_count,
			'view_count_30'		=> $view_count_30,
			'view_count_60'		=> $view_count_60,
			'view_count_90'		=> $view_count_90,
			'visitor_profiles' 	=> $visitor_profiles,
			'chart_data'		=> $chart_data
		);

		if(Session::get('auth_selected_profile_type') == 'O')		
			return View('myviews.orgdash')->with($arr_views);
		else
			return View('myviews.index')->with($arr_views);
	}

	public function dt_profileviews()
	{
		$results = ProfileViews::where('visited_profile_id', '=', Session::get('auth_selected_profile'))
                        ->leftJoin('profiles','profiles.id','=','visited_profile_id')
                        ->orderBy('name')->groupBy('visitor_profile_id');
                //print_r($results);exit;

		return Datatables::of($results)
						->editColumn('organization', function($results) {
							$prof_data = Profile::where('id', '=', $results['visited_profile_id'])->orderBy('name')->get();
                                                        foreach($prof_data as $prof_datas):
                                                           return $prof_datas->name;
                                                        endforeach;
							
						})
                                                ->editColumn('type', function($results) {
							$prof_info = Profile::where('id', '=', $results['visited_profile_id'])->orderBy('name')->get();
                                                         foreach($prof_info as $prof_datas):
                                                            if($prof_datas->profile_type=='O')$prof_type="Organization";
                                                        if($prof_datas->profile_type=='T')$prof_type="Talent";
							return $prof_type;
                                                        endforeach;
                                                       
						})
						->editColumn('country',function($results){
							$location = GeoIP::getLocation($results['ip_address']);
							return $location['country'];
						})
						->editColumn('ip',function($results){
							$location = GeoIP::getLocation($results['ip_address']);
							return $location['ip'];
						})
						->editColumn('pageviews',function($results){
							$view_count = ProfileViews::where('visited_profile_id', '=', Session::get('auth_selected_profile'))->where('visitor_profile_id', '=', $results['visitor_profile_id'])->count();
							return $view_count;
						})						
						->make(true);
	}
}