<?php namespace App\Http\Controllers;

use App\User;
use App\Assets;
use App\Users_likes;
use App\AssetsData;
use App\Profile;
use Validator;
use Session;
use Illuminate\Support\Facades\Input;
use Vimeo\Vimeo;
use Config;
use Illuminate\Http\Request;
use Redirect;
use Response;
use Auth;
use File;
use App\History;


class ResumeController extends Controller {

    private $current_profile_id;
	/*
	|--------------------------------------------------------------------------
	| User Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's users functionality
	| like signup, login, forgot password.
	|
	*/

	/**
	 * Create a new controller instance.
	 *
	 * @return void
	 */
		public function __construct()
		{
			$this->middleware('auth');
                        if(!Session::get('auth_selected_profile')) {
                                return Redirect::to('profile/step1')->with('succ_msg', 'Please Create atleast one profile')->send(); 
                             }
                        $this->current_profile_id = Session::get('auth_selected_profile');
                }

	/**
		 * Show the application login to the user.
		 *
		 * @return Response
		 */
		public function index(Request $request)
		{
                    
                 if($request->input('upload')=='push')
                {  
                    $rule  =  array(
                    'name' => 'required',
                    'attachment' => 'required|max:10000',
                     );
                    $validator = Validator::make(Input::all(),$rule);
                    if ($validator->fails())
                     {
                        return Redirect::to('myresume')
                            ->withErrors($validator->messages());
                     }
                    else
                     {
                       $object= Assets::create([
                                    'name' => trim(Input::get('name')),
                                    'profile_id' => $this->current_profile_id,
                                    'asset_type' => 'R',
                                   ]);
                        $id = $object->id;
                        
                        $image = Input::file('attachment');       
                        $img_name  = $image->getClientOriginalName();
                        $info = pathinfo($img_name);
                        $org_name =  basename($img_name,'.'.$info['extension']);
                        $tmp = explode('.', $img_name);
                        $ext = end($tmp);
                        $filename=$org_name.'_'.$id.'.'.$ext;
                        
                        $destination = 'resumes/';      
                        $image->move($destination, $filename);

                        AssetsData::create([
                                    'asset_id' => $id, 
                                    'path' => $filename,
                                   ]);
                     }
                }       $maxlimit = Config::get('constants.RESUME_LIMIT');
                        $pictures = Assets::getResumes($this->current_profile_id,$maxlimit);
                        $numrows = Assets::getResumelist($this->current_profile_id);
                        //echo '<pre>';print_r($pictures);exit;
			return View('attachments.resume')->with('data',$pictures)->with('numrows',$numrows)->with('maxlimit',$maxlimit)->withMessage('Data inserted');
                     
                    
                }
                public function findlimit(Request $request)
                {
                    $input = $request->all();
                    $take = $input['take'];
                    $skip = $input['skip'];
                    $search_key = $input['sea_key'];
                   // return $take;exit;
                    $this->current_profile_id = Session::get('auth_selected_profile');

                    $likes = Users_likes::where("like_user_id",'=',Auth::user()->id)->where("likes_type",'=','R')->get();

                    $values=array(); 
                    foreach($likes as $val)
                    {
                          $values[]=$val['likes_id'];
                    }

                    $output['count'] = Assets::getRescount($this->current_profile_id,$search_key);
                    $output['values'] = Assets::getResumes($this->current_profile_id,$take,$skip,$search_key);
                    $output['likes']  = $values;
                    echo json_encode($output);
                }
               /*searching pictures*/ 
//                public function picturesearch()
//                {
//                $likes = Users_likes::where("like_user_id",'=',Auth::user()->id)->where("likes_type",'=','R')->get();
//		$values=array(); 
//                foreach($likes as $val)
//                  {
//                      $values[]=$val['likes_id'];
//                  }
//           
//                $search_data = Input::get('searchdata');
//                $pictures = Assets::fileSearch($search_data);
//                return View('attachments.dum_resume')->with('likes',$values)->with('data',$pictures);  
//
//                }
               /*like pictures*/ 
                public function res_likes(Request $request)
                { 
                  $data_id = Input::get('like_id');
                 
                  $pic_det = Assets::where('id','=',$data_id)->get();
                 // echo Auth::user()->id;
             //  print_r($pic_det[0]->profile_id);exit;
                    if(isset($pic_det[0]) && $pic_det[0]->profile_id!=''):   
                        $profiles = Profile::where("id",'=',$pic_det[0]->profile_id)->get();
$likes = Users_likes::where("like_user_id",'=',Auth::user()->id)->where("likes_id",'=',$data_id)->where("likes_type",'=','R')->get();
                      if(isset($likes[0])):
                          $delete=Users_likes::where("like_user_id",'=',Auth::user()->id)->where("likes_id",'=',$data_id)->where("likes_type",'=','R')->delete(); 
                          if($delete):echo "Like"; endif;
                               else:
                           $object= Users_likes::create([
                                    'like_user_id' => trim(Auth::user()->id),
                                    'owner_id' => trim($profiles[0]->user_id),
                                    'likes_id' => trim($pic_det[0]->id),
                                    'likes_type'=>trim($pic_det[0]->asset_type),
                                   ]);  
                           if($object):echo "Unlike"; endif;
                               endif;
                    
                    endif;
                      //return Redirect::back()->with('succ_msg',"Like Updated Successfully");   
                       // $likes = Users_likes::where("like_user_id",'=',Auth::user()->id)->where("likes_type",'=','I')->get();
		      /*  $values=array(); 
                        foreach($likes as $val)
                          {
                              $values[]=$val['likes_id'];
                          }*/
                  //  return $pictures;exit;
                         //return View('profileAssets.ajax_likes')->with('likes',$values)->with('data',$pictures);  
                  
                }
                
              /*Update user Access*/   
               public function update_access($access_id,Request $request)
             {
              if(is_numeric($access_id)):
               $pic_det = Assets::where('id','=',$access_id)->get();
               $input = $request->all();
               if(isset($pic_det[0]) && ($this->current_profile_id==$pic_det[0]->profile_id) && $input['access']): 
                   $picture = Assets::find($pic_det[0]->id); 

                  if($input['access']=='lock'):
                    $picture->access = 'PVT'; 
                  elseif($input['access']=='unlock'):
                    $picture->access = 'PUB'; 
                  else:
                    return Redirect::back()->with('error_msg',"Invalid Request");
                  endif; 
                  
                  /* save access */
                   $picture->save();
                   return Redirect::back()->with('succ_msg',"Picture ".ucwords($input['access'])." Successfully");    
                  /* End save access */               
                else:
                    return Redirect::back()->with('error_msg',"Invalid Request");                
                endif;
            else:
                return Redirect::back()->with('error_msg',"Invalid Request");
            endif;
           }
           public function pic_delete($del_id,Request $request)
           {
              if(is_numeric($del_id)):
              $pic_id=Assets::find($del_id)->where("profile_id",'=',$this->current_profile_id)->where("asset_type",'=','R')->get();
              $pic_data=AssetsData::where('asset_id','=',$del_id)->get()->first();
             
                 $dd = $pic_data->path;
              
          
              if(isset($pic_id[0])):
                  
                    $m_img_path='resumes/'.$dd;
                    if (file_exists($m_img_path))
                    {
                        if(unlink($m_img_path))
                            {
                                 $delete = AssetsData::where('asset_id', '=', $del_id)->delete();
                            }
                    }
              if($delete):
                  $delete1 = Assets::where('id', '=', $del_id)->delete();
                 if($delete1):
                     return Redirect::back()->with('succ_msg',"Resume Deleted Successfully");   
                 else:
                    return Redirect::back()->with('error_msg',"Invalid Request");    
                 endif;
              else:
                 return Redirect::back()->with('error_msg',"Invalid Request");    
              endif;

                else:
                  return Redirect::back()->with('error_msg',"Invalid Request");   
              endif;
              else:
                return Redirect::back()->with('error_msg',"Invalid Request");   
              endif;
           }
           
          public function getDownload($pic_id){
              $doc = AssetsData::where('asset_id','=', $pic_id)->get()->first();
              $file = './resumes/'.$doc->path;
              $file_name=$doc->path;
               if (File::isFile($file))
               { // return $file;exit;
                   
                   $Resumes = History::Addview($this->current_profile_id,$pic_id,'R');
                   if($Resumes)
                   {
                      $header=array('Content-Type', 'text/plain', // txt etc
                                                 'application/msword', // doc
                                                 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', //docx
                                                 'application/vnd.ms-excel', // xls
                                                 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', // xlsx
                                                 'application/pdf',//pdf
                                                 'application/rtf',//rtf
                                );
                     return Response::download($file, $file_name, $header);  
                   }
                  
               }
        
             }
}
