<?php namespace App\Http\Controllers;
use App\Profile; // Profile Model
use Auth; // Auth model
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Input;
use Session;
use Validator;
use Hash;
use App\User;
use App\Users_likes;
use Config;
use URL;

class MylikesController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| MyProfile Controller
	|--------------------------------------------------------------------------
	|
	|
	*/

	/**
	 * Myprofile controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->middleware('auth');
                if(!Session::get('auth_selected_profile')) {
                                return Redirect::to('profile/step1')->with('succ_msg', 'Please Create atleast one profile')->send(); 
                             }
                   $this->current_profile_id = Session::get('auth_selected_profile');
	}

	/**
	 * Show the application Step1 to the user.
	 *
	 * @return Response
	 */

	public function index()
	{ 
           $user_id=Auth::user()->id;
           $pro_likes = Users_likes::getRows($user_id,'P');
           $pic_likes = Users_likes::getRows($user_id,'I');
           $vid_likes = Users_likes::getRows($user_id,'V');
           $res_likes = Users_likes::getRows($user_id,'R');
	   return view('mylikes.index')->with(['pic_likes'=>$pic_likes])->with(['vid_likes'=>$vid_likes])->with(['res_likes'=>$res_likes])->with(['pro_likes'=>$pro_likes]);
	}
        public function showlikes($like_type)
        {
           $user_id=Auth::user()->id;
           $allow_types = array('videos'=>'V','profiles'=>'P','pictures'=>'I','resumes'=>'R');
         /***/
           if(isset($allow_types[$like_type])):
                $liketype = $allow_types[$like_type];
                $maxlimit = Config::get('constants.LIKES_LIMIT');
                if($like_type!='profiles'):
                $likes   = Users_likes::getMylikes($user_id,$liketype,$maxlimit);
                $numrows = Users_likes::getRows($user_id,$liketype);   
                else:
                $likes   = Users_likes::getProlikes($user_id,$liketype,$maxlimit);
                $numrows = Users_likes::getProRows($user_id,$liketype);   
                endif;
               
                return view('mylikes.mylikes')->with(['like_type'=>$liketype])->with(['likes'=>$likes])->with(['numrows'=>$numrows])->with(['maxlimit'=>$maxlimit]);
           else:
                return redirect('mylikes')->with('error_msg',"Invalid Request");   
           endif;    
           
        }
        public function delete_like($like_id)
        {
           $user_id=Auth::user()->id;
          
           $delete=Users_likes::where("like_user_id",'=',Auth::user()->id)->where("id",'=',$like_id)->delete();
           
           if($delete)
           {
                return Redirect::back()->with('succ_msg',"Like Item Deleted Successfully");   
           }
	 //  return view('mylikes.mylikes')->with(['likes'=>$likes])->with(['numrows'=>$numrows])->with(['maxlimit'=>$maxlimit]);
        }
        public function findlimit()
        {
        $user_id=Auth::user()->id;
        $take = Input::get('take');
        $skip = Input::get('skip');
        $like_type = Input::get('likes_type');
        if($like_type!='P'):
        $likes = Users_likes::getMylikes($user_id,$like_type,$take,$skip);
        else:
        $likes = Users_likes::getProlikes($user_id,$like_type,$take,$skip);
        endif;
        
        return json_encode($likes); 

        }
       
           
             
}
