<?php namespace App\Http\Controllers;
use App\Profile; // Profile Model
use Auth; // Auth model
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Input;
use Session;
use Validator;
use Hash;
use App\User;
use App\BusinessYears;
use App\Funding;

class MyaccountController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| MyProfile Controller
	|--------------------------------------------------------------------------
	|
	|
	*/

	/**
	 * Myprofile controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->middleware('auth');
               
		
	}

	/**
	 * Show the application Step1 to the user.
	 *
	 * @return Response
	 */

	public function index()
	{
	//	$profiles = Profile::where('user_id','=',Auth::user()->id);
	//    return view('myprofile.index')->with(['profiles'=>$profiles]);
	    return view('myaccount.index')->with(['error_msg'=>Session::get('error_msg')]);
	}
        public function pswd_view()
        {
            $validation_errors="";	
            return view('changepwd')->with(['validation_errors'=>$validation_errors]);;
         }
            public function pswd_update(Request $request)
            {
                if($request->input('Update')=='Update')
                         {  
                             $rule  =  array(
                             'cur_pswd' => 'required',
                             'password' => 'required|min:6|confirmed',
                             'password_confirmation' => 'required',
                              );
                         
                             $validator = Validator::make(Input::all(),$rule);
                             
                             if ($validator->fails())
                              { 
                                 return Redirect::to('user/changepwd')
                                     ->withErrors($validator->messages());
                              }
                             else
                              { 
                                 $user_data=Auth::user()->password;
                                 $user_id=Auth::user()->id;

                                 if(!Hash::check(Input::get('cur_pswd'), $user_data))
                                 {
                                    return Redirect::back()->with('error_msg',"Invalid Current Password");     
                                 }
                                 else
                                 {
                                      if(Input::get('cur_pswd') == Input::get('password'))
                                      {
                                        return Redirect::back()->with('error_msg',"Your New password and existing password never matched");    
                                      }
                                    else
                                      {
                                       $delete = User::where('id', '=', $user_id)->where('user_type', '=', 'user')->update(array('password' => bcrypt(Input::get('password'))));
                                      }
                                 }
                                // print_r($user_data);exit;


                              }


                         }  
                        
                               return Redirect::to('user/changepwd')->with('succ_msg',"Password Updated Successfully");
           }
           public function profile_view()
           {    $user_id=Auth::user()->id;
                $user_data=User::where('user_type', '=', 'user')->where('deleted', '=', '0')->where('id', '=', $user_id)->get();
                $business_years = BusinessYears::getAllYears();     
                            if(isset($user_data[0])):
                             return View('profile.account_settings')->with(['user_info'=>$user_data,'business_years'=>$business_years]);
                            endif;
           }
             public function profile_update(Request $request)
                {
                    if($request->input('Update')=='Update')
                             {  
                               if($request->input('selected_profile') && $request->input('selected_profile')=='T')
                                {
                                    $rule  =  array(
                                    'name' => 'required|max:255',
                                    'city' => 'required',
                                    'dob' => 'required',
                                    'email' => 'required|email|max:255',
                                    'gender' => 'required',
                                     );
                                }
                                  if($request->input('selected_profile') && $request->input('selected_profile')=='O')
                                {
                                    $rule  =  array(
                                    'name' => 'required|max:255',
                                    'city' => 'required',
                                    'years_in_business' => 'required',
                                    'email' => 'required|email|max:255',
                                     );
                                }
                                 $validator = Validator::make(Input::all(),$rule);
                                 if ($validator->fails())
                                 { 
                                 return Redirect::to('user/account_settings')
                                     ->withErrors($validator->messages());
                                  }
                                 else
                                  {
                                     $user_id=Auth::user()->id;
                                     if(Input::get('dob')){
                                     $get_val= explode('/',Input::get('dob'));
                                     $yy_mm_dd = $get_val[2].'-'.$get_val[0].'-'.$get_val[1];
                                     $dob=  date("Y-m-d", strtotime($yy_mm_dd));
                                     }else {$dob="";}
                                     
                                     if(Input::get('gender')){$gender=Input::get('gender');}else{$gender="";}
                                     
                                     if(Input::get('years_in_business')){$years_in_business=Input::get('years_in_business');}else{$years_in_business="";}
                                    
                                     User::where('id', '=', $user_id)->where('user_type', '=', 'user')->update(array('name' => trim(Input::get('name')),'city' => trim(Input::get('city')),'dob' => $dob,'gender' => trim($gender),'years_in_business'=> trim($years_in_business),'email' => trim(Input::get('email'))));
                                     Funding::where('profile_id', '=', Session::get('auth_selected_profile'))->update(array('years_in_business' => trim($years_in_business)));
                                  }

                                 
                             }  
                              $user_data=User::where('user_type', '=', 'user')->where('deleted', '=', '0')->where('id', '=', $user_id)->get();
                                   return Redirect::to('user/account_settings')->with('data',$user_data)->with('succ_msg',"Profile Updated Successfully");
               }

}
