<?php namespace App\Http\Controllers;
use Auth; // Auth model
use App\Profile; // Profile Model
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Input;
use Session;
use App\Categories;
use App\Industry;
use App\Roles;
use App\Search;
use Config;
use Datatables;
use App\Countries;
use App\Connections;
use App\ConnectionUsers;
use Mail;
use App\User;
use URL;
use App\Currency;
use App\CurrencyUnits;
use App\Import_contacts;
use App\ProfileCategories;
use App\Experience;
use App\Education;
use App\Location;
use App\ProfileLinks;
use App\Awards;
use App\BusinessYears;
use App\GrowthPerYear;
use App\History;
class HomesearchController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Search Controller
	|--------------------------------------------------------------------------
	|
	|
	*/

	/**
	 * Search controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		
		
	}

	public function index(Request $request)
        { 
		//print_r($request->toArray()); exit;
                $search_type = array("everyone"=>"Everyone");	
		        $input = $request->all(); $history_data = '';
		        $parent_data = Categories::getListofCategories('T');
                $currency_all = Currency::getAllCurrency();
                $currency_units = CurrencyUnits::getAllUnits();	
	          	$child_data = Categories::getListofCategoriesLikeArray(true);
		        $industry_data = Industry::getList();
		        $roles_data = Roles::getList();
		        $countries = Countries::orderBy('name')->get();
               
		
		if($request->input('search'))
		{      
		
			 // dd($input);
                        
			$limit = $default_limit = Config::get('constants.PROFILE_SEARCH_LIMIT'); 
			$offset = Config::get('constants.PROFILE_SEARCH_OFFSET');	
			$profile_type = Config::get('constants.PROFILE_SEARCH_DEFAULT_PROFILE_TYPE');
				//echo $profile_type; exit;
			/*echo "<pre>"; 
			print_r($input);
			exit;*/
			unset($input['_token']);
			

			if(isset($input['limit']))
				$limit = $input['limit'];

			if(isset($input['offset']))
				$offset = $input['offset'];

			
				$profile_type ='T';	
                       
               $search_results = Profile::homesearch($input,$limit,$offset,$profile_type);
                           
			   $count_search_results = Profile::homesearch($input,$limit,$offset,$profile_type,true);
			
			
		   return view('search.home_list')->with(['error_msg'=>Session::get('error_msg'),'countries'=>$countries,'search_data'=>$input,'default_limit'=>$default_limit,'total_records'=>$count_search_results,'search_result'=>$search_results]);
		}
		else		
	    return redirect(URL::previous())->with('error_msg',"Invalid search Request");
	}

	public function ajax(Request $request)
	{	
        $input = $request->all();
        $result = array();
              
		$profile_type = 'T';	

		$search_results = Profile::homesearch($input,$input['limit'],$input['offset'],$profile_type);
		$count_search_results = Profile::homesearch($input,$input['limit'],$input['offset'],$profile_type,true);

        
		$result['data'] = $search_results;
               
		$result['total'] = $count_search_results;
		echo json_encode($result);
	}
	public function talent($id,Request $request)
	{

		if(is_numeric($id)):
//			$profile_det = Profile::where('id','=',$id)->where("user_id",'=',Auth::user()->id)->get();
			$profile_det = Profile::where('id','=',$id)->get();

			$countries = Countries::orderBy('name')->get();

			if(isset($profile_det[0])):

				Session::forget('cat_data');
				Session::forget('cat_type');	

				$profile_det[0]->private = false;


				
				/* Categories by profile ID */
				$profile_categories = $profile_experience = $profile_education = $profile_location = $profile_links ='';

				/*echo strpos($profile_det[0]->private_permission,'B,');
				exit;*/

				$profile_categories = ProfileCategories::getCategoriesByProfileID($profile_det[0]->id); 
				$profile_experience = Experience::getExperienceByProfileID($profile_det[0]->id);
                                //print_r($profile_experience); exit;
				$profile_education =  Education::getExperienceByProfileID($profile_det[0]->id);
				$profile_location  =  Location::getExperienceByProfileID($profile_det[0]->id);
				$profile_links = ProfileLinks::getlistByProfile($profile_det[0]->id);
				$profile_awards = Awards::getAwardsByProfileID($profile_det[0]->id);
 				
				$business_years = BusinessYears::getAllYears();		
				$currency_all = Currency::getAllCurrency();		
				$currency_units = CurrencyUnits::getAllUnits();		
				$growth_per_year = GrowthPerYear::getAllPercents();
				$industries = Industry::getListAll(); 				

 				$arr_withs = array(
					'prof_det'=>$profile_det[0],
					'countries'=>$countries,
					'profile_links'=>$profile_links,
					'categories'=>$profile_categories,
					'profile_exp'=>$profile_experience,
					'profile_edu'=>$profile_education,
					'profile_loc'=>$profile_location,
					'profile_aw'=>$profile_awards,
					'error_msg'=>Session::get('error_msg'),
					'succ_msg'=>Session::get('succ_msg')
 				);

 					$view = 'profile.talent';
 					
				    return view('profile.talent')->with($arr_withs);
                            
			else:
				return redirect('/')->with('error_msg',"Invalid Search Details");
			endif;
		else:
			return redirect('/')->with('error_msg',"Invalid Search Details");
		endif;
	
	}
}
