<?php namespace App\Http\Controllers;
use Auth;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Http\Request;
use URL;
use Input;
use App\Subscribe;
use Validator;
use Mail;
use Config;
use App\Assets;
use App\History;
use App\Users_likes;
use App\Content;
class HomeController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Home Controller
	|--------------------------------------------------------------------------
	|
	| This controller renders your application's "dashboard" for users that
	| are authenticated. Of course, you are free to change or remove the
	| controller as you wish. It is just here to get your app started!
	|
	*/

	/**
	 * Create a new controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		//$this->middleware('auth');
            if(Auth::user()):
                   if(Auth::user()->user_type=='admin'):
                 Redirect::to('admin/dashboard')->send();
                   endif; 
                endif;
	}

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function index()
	{
		    $maxlimit = Config::get('constants.HOME_LIMIT');

            $video_data = Assets::getResentVideos($maxlimit);
            $video_data_cnt = Assets::getResentVideoscnt();
		
            $like_type='V';
	    	$video_likes = Users_likes::getvideolikes($like_type,$maxlimit);
	    	$video_likescnt = Users_likes::getvideolikescnt($like_type);

	    	
	    	$video_share = History::getViewsVideos($maxlimit);
	    	$video_sharecnt = History::getViewsVideoscnt();
	    	$content_text = Content::get();
			
			//print_r($content_text); exit;
	    	
		return view('home')->with('like_data',$video_likes)->with('data',$video_data)->with('sharecnt',$video_sharecnt)->with('likecnt',$video_likescnt)->with('datacnt',$video_data_cnt)->with('trend_data',$video_share)->with('content_text',$content_text);
	}
	
	public function subscribe(Request $request)
	{
        $input= $request->all();
		if($request->input('subscribe')=='emails')
		{
			 $data = array('email' => $request->input('email') );


			 $rule  =  array('email'=> 'required|email|max:255' );

             $validator = Validator::make($data,$rule);
                    if ($validator->fails())
                     {
                        return Redirect::to('/')
                            ->withErrors($validator->messages());
                      }
                    else
                     {
                     	   $result = subscribe::where('email','=', $data['email'])->get()->first();
			               if(count($result)){
                     	                           return Redirect::back()->with('error_msg',"You have already subscribed with this email");     
                                             }
                                             else
                                             {
                                                   $result= subscribe::create(['email' => trim(Input::get('email'))]);
                                             }


                     	if($result){
                    	Mail::send('emails.subscribe',['email' => $data['email']], function($message)
					        use($data){
					            $message->to($data['email'])->subject('Welcome!');       		
					        });
                         return Redirect::back()->with('succ_msg',"Email Subscribe Successfully");     
			        }
		}
	}

  }
}
