<?php namespace App\Http\Controllers;
use App\Profile; // Profile Model
use Auth; // Auth model
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Input;
use Session;
use Validator;
use Hash;
use App\User;
use App\History;
use Config;
use URL;

class HistoryController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| MyProfile Controller
	|--------------------------------------------------------------------------
	|
	|
	*/

	/**
	 * Myprofile controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->middleware('auth');
                if(!Session::get('auth_selected_profile')) {
                                return Redirect::to('profile/step1')->with('succ_msg', 'Please Create atleast one profile')->send(); 
                             }
                   $this->current_profile_id = Session::get('auth_selected_profile');
	}

	/**
	 * Show the application Step1 to the user.
	 *
	 * @return Response
	 */
      public function index()
      {
          $video_hist = History::getViews_videos($this->current_profile_id);
          $pic_hist = History::getViews_pictures($this->current_profile_id);
          $res_hist = History::getViews_resumes($this->current_profile_id);
          $pro_hist = History::getViews_profile($this->current_profile_id);
          return View('history.index')->with('videos',$video_hist)->with('pictures',$pic_hist)->with('resumes',$res_hist)->with('profiles',$pro_hist);
      }
       public function delete($access_id,Request $request)
    {

        if(is_numeric($access_id)):
               $history_det = History::where('id','=',$access_id)->get();
               $input = $request->all();
               if(isset($history_det[0]) && (Session::get('auth_selected_profile')==$history_det[0]->user_id)): 

                   $video = History::find($history_det[0]->id); 
                  
                  /* Delete video */
                   if($video->count()>0):
    
                       $video->delete();
                   endif;

                   return redirect(URL::previous())->with('succ_msg',"History Deleted Successfully");    
                  /* End Delete video */               
                else:
                    return redirect(URL::previous())->with('error_msg',"Invalid Request");                
                endif;
            else:
                return redirect(URL::previous())->with('error_msg',"Invalid Request");
            endif;
        /*echo "connect";
        exit;
      */
    }
	
}
