<?php namespace App\Http\Controllers;
use App\Profile; // Profile Model
use Auth; // Auth model
use Request;
use Response;
use Storage;
use App\Invitations;
/* Funding required models */
	use App\Funding,App\FundingAssets;
/* End Funding required models */

class DownloadController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Download Controller
	|--------------------------------------------------------------------------
	|
	|
	*/

	/**
	 * Download controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		$this->middleware('auth');
               
	}

	/**
	 * Downloading public files.
	 *
	 * @return Response
	 */

	public function index()
	{
		$profiles = Profile::where('user_id','=',Auth::user()->id);
	    return view('myprofile.index')->with(['profiles'=>$profiles]);
	}

	public function funding_download($funding_id,$file_type)
	{
		$funding = Funding::find($funding_id);
		if($funding)
		{
			$filename = $funding->$file_type;
			$org_file_type = $file_type.'_name';
			$orgname = $funding->$org_file_type;
			return response()->download('./uploads/funding_business/'.$filename, $orgname);
		}
		else
		{
			/*echo "<pre> cnt";
			print_r($funding);
			exit;*/
		}
	}

	public function funding_assets_download($funding_assets_id)
	{
		$funding = FundingAssets::find($funding_assets_id);
		if($funding)
		{
			$filename = $funding->filename;
			$orgname = $funding->name;
			if($funding->type='DOCS')
				$folder = 'docs';
			else if($funding->type='IMAGES')
				$folder = 'pics';
			return response()->download('./uploads/funding_assets/'.$folder.'/'.$filename, $orgname);
		}
		else
		{
			/*echo "<pre> cnt";
			print_r($funding);
			exit;*/
		}
	}

	public function inv_attachment_download($inv_id)
	{
		$inv = Invitations::find($inv_id);
		if($inv)
		{
			$filename = $inv->attachment;
			$folder = 'uploads/invitation_attachments';

			return response()->download($folder.'/'.$filename);
		}
		else
		{
			/*echo "<pre> cnt";
			print_r($funding);
			exit;*/
		}
	}
}
