<?php namespace App\Http\Controllers;
use App\Profile;
use App\Experience;
use App\Connections;
use App\ProfileViews;
use App\Mentor;
use App\Messages;// Profile Model
use Auth; // Auth model
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Input;
use Session;
use Validator;
use Hash;
use App\User;

class DashboardController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| MyProfile Controller
	|--------------------------------------------------------------------------
	|
	|
	*/

	/**
	 * Myprofile controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{ //echo 44; exit;
		$this->middleware('auth');
                if(!Session::get('auth_selected_profile')) {
                                return Redirect::to('profile/step1')->with('succ_msg', 'Please Create atleast one profile')->send(); 
                             }
                   $this->current_profile_id = Session::get('auth_selected_profile');
	}

	/**
	 * Show the application Step1 to the user.
	 *
	 * @return Response
	 */

	public function index()
	{ 
            $result = Profile::find(array('id'=>Session::get('auth_selected_profile')))->first();
            $work = Experience::where(array('profile_id'=>Session::get('auth_selected_profile')))->first();
            $connect_count = Connections::select('connetions.id')
                                         ->join('profiles', 'profiles.id', '=', 'connections.receiver_profile_id')
                                        ->where('status','=','Pending')
                                        ->where('connections.receiver_profile_id',Session::get('auth_selected_profile'))->count();
            $profile_count = ProfileViews::getLastViewerIds(Session::get('auth_selected_profile'), 7);
            $profile_count = count($profile_count);
           
            if(empty($result->profile_image)){ 
            $url = 'default-profile.png';}
                        else { 
                        $url = $result->profile_image;}
            
            $result->profile_image = $url;
             
	   $msg = Messages::getmessageNew(Auth::user()->id)->get()->toArray();
           
           $connections = Connections::getrecordsnew(Session::get('auth_selected_profile'));
           $connections_cnt = Connections::getrecordstotal(Session::get('auth_selected_profile'));
           
                for($i=0;$i<count($connections);$i++)
                {
                    if($connections[$i]['profile_image']=='')
                    {
                        $connections[$i]['profile_image']='default-profile.png';
                    }
                }
             //print_r($connections); exit ;   
              $mentor = Mentor::getinactivementor(Session::get('auth_selected_profile'));
		//echo '<pre>'; print_r($mentor);exit;
	    return view('dashboard.index')->with(['error_msg'=>Session::get('error_msg'),'connections'=>$connections,'msg'=>$msg,'result'=>$result,
                'work'=>$work,'conectioncount'=>count($connections_cnt) ,'profcount'=>$profile_count,'mentor'=>$mentor]);
	}
        

}
