<?php namespace App\Http\Controllers;
use Auth; // Auth model
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Input;
use App\Contact;
use App\User;
use Mail;
use Validator;
use URL;
class ContactController extends Controller {

	/*
	|--------------------------------------------------------------------------
	| Search Controller
	|--------------------------------------------------------------------------
	|
	|
	*/

	/**
	 * Search controller instance.
	 *
	 * @return void
	 */
	public function __construct()
	{
		
		
	}

	public function index(Request $request)
	{
	     
               if($request->input('contact')=='contact')
                {
                     $data = array(
                                'firstname' => $request->input('firstname'),
                                'lastname'  => $request->input('lastname'),
                                'email'     => $request->input('email'),
                                'phone'     => $request->input('phone'),
                                'company'   => $request->input('company'),
                                'state'     => $request->input('state'),
                               );
                     
                      $rule  =  array(
                                'firstname' => 'required|max:200',
                                'lastname'  =>'required|max:200',
                                'email'     => 'required|email|max:200',
                                'phone'     => 'required|min:8|max:16',
                                'company'   => 'required',
                                'state'     => 'required',
                                );
                    $validation = Validator::make(Input::all(),$rule);
                    if($validation->fails())
                    {   
                        return Redirect::to('contact')
                            ->withErrors($validation->messages());
                    }
                    else
                    {    
                        
                        $admin ="";
                         $result = Contact::create([
                                    'firstname'     => $data['firstname'],
                                    'lastname'      => $data['lastname'],
                                    'email'         => $data['email'],
                                    'phone'         => $data['phone'],
                                    'company'       => $data['company'],
                                    'state'         => $data['state'],
                                      ]);
                   
                       $admin = User::where('user_type', 'admin')->first();
                     //  echo '<pre>'.$admin['email'];exit;                        
                       if($result){
                           
                           
                             Mail::send('emails.contact_receiver', ['name' => $admin['name'],'data' => $data], function($message)
					        use($admin){
					            $message->to($admin['email'], $admin['name'])->subject('Contact Form Details');       		
					        });
     
                                                 
                               Mail::send('emails.contact_sender', $data, function($message)
					        use($data){
					            $message->to($data['email'], $data['firstname'])->subject('Contact Form Details');       		
					        });
                              $msg='Thank you for contacting us,Our team will get back to you shortly';
                    	      return Redirect::to('contact')->with('succ_msg',$msg);
                                }
                    }
                 }  
           
	}
        
        
        
}
