<?php namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
class FundingAssets extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'funding_business_assets';

	/** 
	 * The attributes that are mass assignable.
	 *
	 * @var array 
	 */
	protected $fillable = ['funding_business_id', 'name','filename', 'url', 'delete_url', 'type'];	


	protected function get_by_funding_id($fb_id)
	{
		$assets = $this->where('funding_business_id', '=', $fb_id)->get();

		if( $assets->count() > 0 )
		{
			foreach($assets as $fkey => $fval)
			{
				$result[] = $fval;
			}
			return $result;
		}
		else
		{
			return false;
		}	

	}

	protected function getVideos_by_funding_id($fb_id)
	{
		$assets = $this->select('funding_business_assets.id','access','url','name','thumb_img','processed')
				->join('funding_business_assets_data','funding_business_assets_data.funding_business_assets_id','=','funding_business_assets.id')
				->where('funding_business_id', '=', $fb_id)->get();

		if( $assets->count() > 0 )
		{
			foreach($assets as $fkey => $fval)
			{
				$result[] = $fval;
			}
			return $result;
		}
		else
		{
			return false;
		}	

	}


	protected function getUnprocessedVideos()
	{
		return $result = $this->select('id','url','processed')
	        ->where('processed','=','0')
	        ->where ('type','=','VIDEOS')
	    	->get();
	}
}