<?php namespace App;

use Illuminate\Database\Eloquent\Model;
use DB;
class Funding extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'funding_business';

	/** 
	 * The attributes that are mass assignable.
	 *
	 * @var array 
	 */
	protected $fillable = ['profile_id','revenue_det','years_in_business','assets_currency','assets_currency_units','nature_business','industry_focus', 'min_investment_currency', 'min_investment_currency_units', 'max_investment_currency', 'max_investment_currency_units','funding_type','investment_amt','max_investment_usd_val','min_investment_amt','min_investment_fin_amt','max_investment_amt','max_investment_fin_amt','financial_service','portfolio','growth','emp_strength'];	

	protected function getByProfile($profile_id,$funding_type='R')
	{
		$funding = $this->where('profile_id', '=', $profile_id)->where('funding_type','=',$funding_type)->get();

		if( $funding->count() == 1 )
		{
			foreach($funding as $fkey => $fval)
			{
				$result = $fval;
			}
			return $result;
		}
		else
		{
			return false;
		}	

	}

}