<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Experience extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'experience';

	/** 
	 * The attributes that are mass assignable.
	 *
	 * @var array 
	 */
	protected $fillable = ['profile_id','location','company_name','description','partners','from_date','to_date'];

	protected function getExperienceByProfileID($profile_id)
	{
		$result = $this->where('profile_id','=',$profile_id)
				->orderBy('id', 'desc')
				->get();
		$return_value=array();				
		foreach($result as $r)			
		{
			$from = explode('-',$r->from_date);	
			$to = explode('-',$r->to_date);	
			$return_value[$r->id] = array(
					'id' =>$r->id,
					'from_date' =>date('F-Y',strtotime($r->from_date)),
					//'to_date' => if($r->to_date!=0000-00-00) date('F-Y',strtotime($r->to_date)),
					'exp_from_mm' => $from[1],
					'exp_from_yy' => $from[0],
					//'exp_to_mm' => $to[1],
					//'exp_to_yy' => $to[0],
					'exp_location'=>$r->location,
					'exp_company' => $r->company_name,
					'exp_description' =>$r->description,
                                        'exp_partners' => $r->partners,
				); 
                        if($to[1]!='00')
			$return_value[$r->id]['exp_to_mm'] = $to[1];
			else
			$return_value[$r->id]['exp_to_mm'] = '';
                        
                        if($to[0]!='0000')
			$return_value[$r->id]['exp_to_yy'] = $to[0];
			else
			$return_value[$r->id]['exp_to_yy'] = '';
                        
			if($r->to_date!='0000-00-00')
			$return_value[$r->id]['to_date'] = date('F-Y',strtotime($r->to_date));
			else
			$return_value[$r->id]['to_date'] = '-';	
		}	
		return $return_value;
	}

}
