<?php namespace App\Exceptions;

use Exception;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Auth;
use Illuminate\Support\Facades\Redirect;

class Handler extends ExceptionHandler {

	/**
	 * A list of the exception types that should not be reported.
	 *
	 * @var array
	 */
	protected $dontReport = [
		'Symfony\Component\HttpKernel\Exception\HttpException'
	];

	/**
	 * Report or log an exception.
	 *
	 * This is a great spot to send exceptions to Sentry, Bugsnag, etc.
	 *
	 * @param  \Exception  $e
	 * @return void
	 */
	public function report(Exception $e)
	{
		return parent::report($e);
	}

	/**
	 * Render an exception into an HTTP response.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @param  \Exception  $e
	 * @return \Illuminate\Http\Response
	 */
	public function render($request, Exception $e)
	{
		if($this->isHttpException($e))
		{
			switch ($e->getStatusCode()) {

				case 404:
				    if ( $request->is('administrator/*') || $request->is('admin/*') || (isset(Auth::user()->user_type) && Auth::user()->user_type == 'admin') )
                                     {    if(Auth::user()->user_type != 'user' || Auth::user()->user_type=""){return Redirect::back()->with('error_msg',"Invalid Request");}    }
			            else
                                     {    return Redirect::back()->with('error_msg',"Invalid Request");    }
					break;

				case '503':
					return \Response::view('errors.503');
					break;

				default:
					return $this->renderHttpException($e);
					break;
			}
		}
		else
		{
				return parent::render($request, $e);
                //  return Redirect::back()->with('error_msg',"Invalid Request");  
		}
	}

}
