<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Education extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'education';

	/** 
	 * The attributes that are mass assignable.
	 *
	 * @var array 
	 */
	protected $fillable = ['profile_id','location','partners','company_name','description','from_date','to_date'];

	protected function getExperienceByProfileID($profile_id)
	{
		$result = $this->where('profile_id','=',$profile_id)
				->orderBy('id', 'desc')
				->get();
		$return_value=array();				
		foreach($result as $r)			
		{
			$from = explode('-',$r->from_date);	
			$to = explode('-',$r->to_date);	
			$return_value[$r->id] = array(
					'id' =>$r->id,
                                        'from_date' =>date('F-Y',strtotime($r->from_date)),
					//'from_date' =>$r->from_date,
					//'to_date' =>$r->to_date,
					'edu_from_mm' => $from[1],
					'edu_from_yy' => $from[0],
					//'edu_to_mm' => $to[0],
					//'edu_to_yy' => $to[1],
					'edu_location'=>$r->location,
					'edu_company' => $r->company_name,
					'edu_description' =>$r->description,
                                        'edu_partners' =>$r->partners,
				); 
                        if($to[1]!='00')
			$return_value[$r->id]['edu_to_mm'] = $to[1];
			else
			$return_value[$r->id]['edu_to_mm'] = '';
                        
                        if($to[0]!='0000')
			$return_value[$r->id]['edu_to_yy'] = $to[0];
			else
			$return_value[$r->id]['edu_to_yy'] = '';
                        
                        if($r->to_date!='0000-00-00')
			$return_value[$r->id]['to_date'] = date('F-Y',strtotime($r->to_date));
			else
			$return_value[$r->id]['to_date'] = '-';	
		}	
		return $return_value;
	}

}
