<?php namespace App;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\ConnectionUsers;
class Connections extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'connections';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['sender_profile_id','receiver_profile_id','message','id'];

	
        protected function create_record($sender_profile_id,$receiver_profile_id,$message)
        {
            $create = array();
            $create['sender_profile_id'] = $sender_profile_id;
            $create['receiver_profile_id'] = $receiver_profile_id;
            $create['message'] = $message;
            $create['is_read'] = 'No';
            return $this->create($create);

         }
          protected function getrecordstotal($receiver_profile_id)
         {
              $result = $this->select('connection_users.id')   
                            ->join('connection_users','connection_users.connection_id','=','connections.id')
                            ->where('connection_users.profile_id','=',$receiver_profile_id)
                            ->where('connections.status','<>','Pending')->get()->toArray();
              return $result;
         }
         protected function getrecords($receiver_profile_id)
         {   
             $first = $this->select('sender_profile_id','connections.status','connections.created_at','connections.id','connection_users.is_read','name','profile_image','profile_type','message')                            
                            ->join('profiles', 'profiles.id', '=', 'connections.sender_profile_id')
                            ->join('connection_users','connection_users.connection_id','=','connections.id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('connections.status','Pending')
                            ->where('connections.receiver_profile_id',$receiver_profile_id)
                            ->where('connection_users.profile_id',$receiver_profile_id)
                            ->groupBy('connections.sender_profile_id')->get()->toArray();
             
             $result = $this->select('sender_profile_id','connection_users.is_read','connections.status','connections.created_at','connections.id','name','profile_image','profile_type','message')                            
                            ->join('profiles', 'profiles.id', '=', 'connections.sender_profile_id')
                            ->join('connection_users','connection_users.connection_id','=','connections.id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('connections.status','Active')
                            ->where('connection_users.profile_id',$receiver_profile_id)
                            ->where('connections.receiver_profile_id',$receiver_profile_id)
                            ->groupBy('connections.sender_profile_id')
                            ->get()->toArray();
             
             $resultnew = $this->select('receiver_profile_id as sender_profile_id','connection_users.is_read','connections.status','connections.created_at','name','connections.id','profile_image','profile_type','message')                            
                            ->join('profiles', 'profiles.id', '=', 'connections.receiver_profile_id')
                             ->join('connection_users','connection_users.connection_id','=','connections.id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('connection_users.profile_id',$receiver_profile_id)
                            ->where('connections.status','=','Active')                            
                            ->where('connections.sender_profile_id',$receiver_profile_id)
                            ->groupBy('connections.receiver_profile_id')
                            ->get()->toArray();
           
            
             $result = array_merge($first,$result,$resultnew);
             //print_r($resultnew);exit;
            return $result;
         }
         
         protected function getrecordsnew($receiver_profile_id)
         {      //echo $receiver_profile_id; exit;
             $result = $this->select('sender_profile_id','connection_users.is_read','connections.status','connections.created_at','connections.id','name','profile_image','message')                            
                            ->join('profiles', 'profiles.id', '=', 'connections.sender_profile_id')
                            ->join('connection_users','connection_users.connection_id','=','connections.id')
                            //->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('connection_users.profile_id','=',$receiver_profile_id)
                            ->where('connection_users.is_read','=','No')
                            //->where('connections.status','Active')
                            ->where('connections.receiver_profile_id',$receiver_profile_id)->get()->toArray();
                            //->groupBy('connections.sender_profile_id')->get()->toArray();             
            if(empty($result)):
                       $result = $this->select('sender_profile_id','connection_users.is_read','connections.status','connections.created_at','connections.id','name','profile_image','message')                            
                            ->join('profiles', 'profiles.id', '=', 'connections.receiver_profile_id')
                            ->join('connection_users','connection_users.connection_id','=','connections.id')
                            //->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('connection_users.profile_id','=',$receiver_profile_id)
                            ->where('connection_users.is_read','=','No')
                           // ->where('connections.status','Active')
                            ->where('connections.sender_profile_id',$receiver_profile_id)->get()->toArray();
                           
                       endif;
                         
             return $result;
         }
         
         protected function getMessages($msg_id)
         {
              return $result = $this->select('sender_profile_id','connection_users.is_read','connections.created_at','message','name','connections.id')                            
                            ->join('profiles', 'profiles.id', '=', 'connections.sender_profile_id')
                            ->where('connections.id',$msg_id)->first();
         }
           protected function getMessagesInfo($msg_id,$profile_id)
         {
              return $result = $this->select('sender_profile_id','receiver_profile_id', 'connection_users.is_read','folder','connections.created_at','connections.status','connections.updated_at','message','name','connections.id')                            
                            ->join('connection_users','connection_users.connection_id','=','connections.id')
                            ->join('profiles', 'profiles.id', '=', 'connection_users.profile_id')
                            ->where('connection_users.profile_id','=',$profile_id)
                            ->where('connections.id',$msg_id)->first();
         }
         
         protected function connectionactive($profileid,$connectusreid)
         {
             $result = $this->select('sender_profile_id','status','connection_users.is_read','connections.created_at','name','profile_image')                            
                            ->join('profiles', 'profiles.id', '=', 'connections.sender_profile_id')
                            ->where('status','pending')
                            ->where('connections.receiver_profile_id',$receiver_profile_id)->get()->toArray();
         }
		 protected function findconnections($receiver_profile_id)
         {             
             $result = $this->select('sender_profile_id','connection_users.is_read','status','connections.created_at','name','profile_image')                            
                            ->join('profiles', 'profiles.id', '=', 'connections.sender_profile_id')
                            ->where('profiles.id', '!=', $receiver_profile_id)
                            ->where('status','Pending')
                            ->where('connections.receiver_profile_id',$receiver_profile_id)
                            ->groupBy('connections.sender_profile_id')->count();
             //print_r($result); exit;
             return $result;
         }

}

