<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class CategoryRoles extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'category_roles';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['profile_id','cat_id','role_id'];

	protected function getRolesByProfileID($profile_id)
	{
		$result = $this->where('profile_id','=',$profile_id)
				->orderBy('role_id', 'asc')
				->get();

		$return_value=array();
			foreach($result as $res):
				$return_value[$res->cat_id][] = $res->role_id;
			endforeach;
		return $return_value;
	}


}
