<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class CategoryIndustry extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'category_industry';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['profile_id','cat_id','industry_id'];

	protected function getIndustryByProfileID($profile_id)
	{
		$result = $this->where('profile_id','=',$profile_id)
				->orderBy('industry_id', 'asc')
				->get();

		$return_value=array();
			foreach($result as $res):
				$return_value[$res->cat_id][] = $res->industry_id;
			endforeach;
		return $return_value;
	}


}
