<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Categories extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'categories';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['name','type','ref_cat_id'];

	protected function getListofCategories($type='T',$parent=false)
	{
		if($parent)
			$result = $this->where('type','=',$type)->where('ref_cat_id','<>','0')->get();
		else
			$result = $this->where('type','=',$type)->where('ref_cat_id','=','0')->get();
		return $result;

		/*$result_array = array();
		foreach($result as $r)
		{
			$result_array[$r->id] = $r->name;
		}
		return $result_array;*/
	}

	protected function getListofCategoriesLikeArray($parent=false)
	{
		$result_array = array();
		if($parent):
			$result = $this->where('ref_cat_id','<>','0')->get();
			foreach($result as $ch)
			{
				$result_array[$ch->ref_cat_id][]=array("id"=>$ch->id,"name"=>$ch->name);
			}	
			return $result_array;
		else:
			$result = $this->where('ref_cat_id','=','0')->get();
			foreach($result as $r)
			{
				$result_array[$r->id] = array("id"=>$r->id,'name'=>$r->name);
			}
			return $result_array;
		endif;

	}

}
