<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Awards extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'awards';

	/** 
	 * The attributes that are mass assignable.
	 *
	 * @var array 
	 */
	protected $fillable = ['profile_id','location','company_name','description','award_date'];

	protected function getAwardsByProfileID($profile_id)
	{
		$result = $this->where('profile_id','=',$profile_id)
				->orderBy('id', 'desc')
				->get();
		$return_value=array();				
		foreach($result as $r)			
		{
			$from = explode('-',$r->award_date);	
			$return_value[$r->id] = array(
					'id' =>$r->id,
					'from_date' =>$r->award_date,
					'aw_from_mm' => $from[0],
					'aw_from_yy' => $from[1],
					'aw_location'=>$r->location,
					'aw_company' => $r->company_name,
					'aw_description' =>$r->description,
				); 
		}	
		return $return_value;
	}

}
