<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class AssetsData extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'assets_data';

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = ['path','asset_id','thumb_img'];

	
	protected function getData($asset_id)
	{
		$asset_data = $this->select('path')->where('asset_id', '=', $asset_id);
		$result = array();
		foreach ($asset_data as $key => $value) {
			$result[$key] = $value;
		}
		return $result;
	}
}
