<?php namespace App;

use Illuminate\Database\Eloquent\Model;

class Assets extends Model {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'assets';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['name','asset_type','profile_id','processed'];

    protected function getVideos($profile_id,$take,$skip=0,$sea_key='')
    {
        $where = '';
        if($sea_key)
            $where = "assets.name LIKE '%".$sea_key."%' AND access='PUB'";
        else
            $where = "profile_id = ".$profile_id;

        return $result = $this->select('assets.profile_id','assets.id','assets.name','assets_data.path','assets.processed','assets_data.thumb_img','assets.access')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
                //->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','V')
                ->whereRaw($where)
                ->orderBy('assets.created_at','desc')
                ->skip($skip)
                ->take($take)
                ->get();
    }
    protected function getResentVideos($take,$skip=0,$sea_key='')
    {
        

        return $result = $this->select('assets.profile_id','assets.id','assets.name','profiles.name as pro_name','assets_data.path','assets.processed','assets_data.thumb_img','assets.access')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                 ->join('profiles', 'assets.profile_id', '=', 'profiles.id')              
                //->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','V')
                ->where ('profiles.profile_type','=','T')
                ->orderBy('assets.created_at','desc')
                ->skip($skip)
                ->take($take)
                ->get();
    }
      protected function getResentVideoscnt($sea_key='')
    {
        

         $result = $this->select('assets.profile_id','assets.id','assets.name','profiles.name as pro_name','assets_data.path','assets.processed','assets_data.thumb_img','assets.access')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                 ->join('profiles', 'assets.profile_id', '=', 'profiles.id')              
                //->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','V')
                ->where ('profiles.profile_type','=','T')
                ->orderBy('assets.created_at','desc')
                ->get();
        return  $result->count();
    }
    
 
    
    protected function getVideosCount($profile_id,$sea_key='')
    {
        $where = '';
        if($sea_key)
            $where = "assets.name LIKE '%".$sea_key."%' AND access = 'PUB'";
        else
            $where = "profile_id = ".$profile_id;
/*echo $where;
exit;*/
        return $result = $this->select('assets.id','assets.name','assets_data.path','assets.processed','assets_data.thumb_img','assets.access')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
                //->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','V')
                ->whereRaw($where)
                ->orderBy('assets.created_at','desc')
                ->count();
    }
    protected function getUnprocessedVideos()
    {
        return $result = $this->select('assets.id','assets.name','assets_data.path','assets_data.id as assets_data_id','assets.processed')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                ->where('processed','=','0')
                ->where ('asset_type','=','V')
                ->get();
    }

//    protected function getVideoSearch($search_data)
//    {
//        return $result = $this->select('assets.id','assets.profile_id','assets.name','assets_data.path','assets.processed','assets_data.thumb_img','assets.access')
//                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
//                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
//                ->where('assets.name', 'LIKE', '%'. $search_data .'%')
//                ->where ('asset_type','=','V')
//                ->where ('access','=','PUB')
//                ->orderBy('assets.created_at','desc')
//                ->get();
//    }
    
     protected function getPictures($profile_id,$take,$skip=0,$sea_key='')
    {  
             $where = '';
        if($sea_key)
            $where = "assets.name LIKE '%".$sea_key."%' AND access='PUB'";
        else
            $where = "profile_id = ".$profile_id;
        return $result = $this->select('assets.profile_id','assets.id','assets.name','assets_data.path','assets.processed','assets.access')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
                //->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','I')
                ->whereRaw($where)
                ->orderBy('assets.created_at','desc')
                ->skip($skip)
                ->take($take)
                ->get();
            
      
    }
    protected function getPiccount($profile_id,$sea_key='')
    {
        $where = '';
        if($sea_key)
            $where = "assets.name LIKE '%".$sea_key."%' AND access = 'PUB'";
        else
            $where = "profile_id = ".$profile_id;
/*echo $where;
exit;*/
        return $result = $this->select('assets.id','assets.name','assets_data.path','assets.processed','assets.access')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
                //->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','I')
                ->whereRaw($where)
                ->orderBy('assets.created_at','desc')
                ->count(); 
    }
        protected function getRows($profile_id,$asset_type='I')
    {
         $result = $this->select('assets.id','assets.name','assets.profile_id','assets_data.path','assets.access','assets.processed')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                ->where('profile_id','=',$profile_id)
                ->where ('asset_type','=',$asset_type)
                ->orderBy('assets.created_at','desc')
        ->get();
         return  $result->count();
    }
    protected function getRowsList($profile_id,$asset_type='I')
    {
         $result = $this->select('assets.id','assets.name','assets.profile_id','assets_data.path','assets.access','assets.processed','assets_data.thumb_img')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                ->where('profile_id','=',$profile_id)
                ->where ('asset_type','=',$asset_type)
                ->orderBy('assets.created_at','desc')
        ->get();
         return  $result;
    }
//       protected function getSearch($search_data)
//    {
//         $result = $this->select('assets.id','assets.name','assets.profile_id','assets_data.path','assets.access','assets.processed')
//              ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
//                                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
//              ->where('assets.name', 'LIKE', '%'. $search_data .'%')
//                ->where ('asset_type','=','I')
//                 ->where ('access','=','PUB')
//                ->orderBy('assets.created_at','desc')
//      ->get();
//         return  $result; 
//    }
//    
     protected function getResumes($profile_id,$take,$skip=0,$sea_key='')
    {
        
         $where = '';
        if($sea_key)
            $where = "assets.name LIKE '%".$sea_key."%' AND access='PUB'";
        else
            $where = "profile_id = ".$profile_id;
        
        return $result = $this->select('assets.profile_id','assets.id','assets.name','assets_data.path','assets.processed','assets.access')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
                //->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','R')
                ->whereRaw($where)
                ->orderBy('assets.created_at','desc')
                ->skip($skip)
                ->take($take)
            ->get();
            
    }
    
    protected function getResumelist($profile_id)
    {
         $result = $this->select('assets.id','assets.profile_id','assets.access','assets.name','assets_data.path','assets.processed')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                ->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','R')
                ->orderBy('assets.created_at','desc')
        ->get();
         return  $result->count();
    }
    
    protected function getRescount($profile_id,$sea_key='')
    {
        $where = '';
        if($sea_key)
            $where = "assets.name LIKE '%".$sea_key."%' AND access = 'PUB'";
        else
            $where = "profile_id = ".$profile_id;
/*echo $where;
exit;*/
        return $result = $this->select('assets.id','assets.name','assets_data.path','assets.processed','assets.access')
                ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
                                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
                //->where('profile_id','=',$profile_id)
                ->where ('asset_type','=','R')
                ->whereRaw($where)
                ->orderBy('assets.created_at','desc')
                ->count(); 
    }
//          protected function fileSearch($search_data)
//    {
//         $result = $this->select('assets.id','assets.profile_id','assets.access','assets.name','assets_data.path','assets.processed')
//              ->join('assets_data', 'assets.id', '=', 'assets_data.asset_id')
//                                ->join('profiles', 'assets.profile_id', '=', 'profiles.id')
//              ->where('assets.name', 'LIKE', '%'. $search_data .'%')
//            
//                ->where ('asset_type','=','R')
//                ->where ('access','=','PUB')
//                ->orderBy('assets.created_at','desc')
//      ->get();
//         return  $result;
//    }
    

}

